/*****************************************************************************
*  LPC81x SCT demo
*
*  Use the 32-bit unified counter to toggle SCT_OUT_0 every 100 msec
*****************************************************************************/
#include "LPC8xx.h"

void SCT_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 8);                 // enable the SCT clock

    LPC_SCT->CONFIG |= 1;                                  // unified timer

    LPC_SCT->MATCH[0].U     = (SystemCoreClock/10)-1;      // match 0 @ 100 msec
    LPC_SCT->MATCHREL[0].U  = (SystemCoreClock/10)-1;

    LPC_SCT->EVENT[0].STATE = 0x00000001;                  // event 0 only happens in state 0
    LPC_SCT->EVENT[0].CTRL  = (0 << 0)  |                  // related to match 0
                              (1 << 12) |                  // COMBMODE[13:12] = match condition only
                              (1 << 14) |                  // STATELD[14] = STATEV is loaded into state
                              (1 << 15);                   // STATEV[15] = 1

    LPC_SCT->EVENT[1].STATE = 0x00000002;                  // event 1 only happens in state 1
    LPC_SCT->EVENT[1].CTRL  = (0 << 0)  |                  // related to match 0
                              (1 << 12) |                  // COMBMODE[13:12] = match condition only
                              (1 << 14) |                  // STATELD[14] = STATEV is loaded into state
                              (0 << 15);                   // STATEV[15] = 0

    LPC_SCT->OUT[0].SET = (1 << 0);                        // event 0 will set SCT_OUT_0
    LPC_SCT->OUT[0].CLR = (1 << 1);                        // event 1 will clear SCT_OUT_0
    LPC_SCT->LIMIT_L    = 0x0003;                          // events 0 and 1 are used as counter limit

    LPC_SCT->CTRL_U &= ~(1 << 2);                          // unhalt it by clearing bit 2 of the CTRL register
}
